/*
 * Decompiled with CFR 0.152.
 */
package com.jab125.thonkutil;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class Main {
    public static void main(String[] args) {
        ResourceBundle warningApi = ResourceBundle.getBundle("lang/ThonkUtil", Locale.getDefault(), new ResourceBundle.Control(){

            /*
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                block13: {
                    String bundleName = this.toBundleName(baseName, locale);
                    String resourceName = this.toResourceName(bundleName, "properties");
                    try (InputStream stream = loader.getResourceAsStream(resourceName);){
                        PropertyResourceBundle propertyResourceBundle;
                        if (stream == null) break block13;
                        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                            propertyResourceBundle = new PropertyResourceBundle(reader);
                        }
                        return propertyResourceBundle;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return super.newBundle(baseName, locale, format, loader, reload);
            }
        });
        String message = warningApi.getString("thonkutil.warning");
        if (GraphicsEnvironment.isHeadless()) {
            System.err.println(message);
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ReflectiveOperationException | UnsupportedLookAndFeelException exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, message);
            System.exit(-1);
        }
    }
}

